/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.api.VWWorkflowDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.event.VWMapChangedEvent;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.workflow.VWBaseFieldTableModel;
import filenet.vw.toolkit.design.property.workflow.VWTableItemWrapper;
import filenet.vw.toolkit.utils.VWInstruction;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.mapui.VWMapCache;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;

public final class VWMapTableModel
extends VWBaseFieldTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_SOURCE = 0;
    public static final int COL_NAME = 1;
    public static final int COL_DESCRIPTION = 2;
    private JComponent m_uiContainer = null;
    private String m_description = "";

    public VWMapTableModel(VWAuthPropertyData authPropertyData, JComponent uiContainer) {
        super(authPropertyData);
        this.m_uiContainer = uiContainer;
    }

    public void deleteItem(int nRowIndex) {
        block6: {
            try {
                VWMapDefinition mapDef;
                if (!this.canDeleteRow(nRowIndex)) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.canDelete() && (mapDef = (VWMapDefinition)wrapper.getValue()) != null && this.m_authPropertyData.deleteMapDefinition(this, mapDef.getName(), this.m_uiContainer) != null) {
                    if (wrapper.isOverridden()) {
                        wrapper.deleteOverriddenValue();
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        this.m_rowData.removeElementAt(nRowIndex);
                        this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    public void reinitialize() {
        try {
            VWMapCache mapCache;
            this.m_description = "";
            super.reinitialize();
            if (this.m_authPropertyData != null && (mapCache = this.m_authPropertyData.getMapCache()) != null) {
                int i;
                VWMapDefinition[] mapDefs;
                if (this.m_authPropertyData.getShowInheritedProperties() && (mapDefs = mapCache.getBaseMapDefinitions()) != null) {
                    for (i = 0; i < mapDefs.length; ++i) {
                        this.m_rowData.addElement(new VWTableItemWrapper(1, mapDefs[i]));
                    }
                }
                if ((mapDefs = mapCache.getCurrentMapDefinitions()) != null) {
                    for (i = 0; i < mapDefs.length; ++i) {
                        int nIndex = this.findIndex(mapDefs[i].getName());
                        if (nIndex != -1) {
                            this.overrideTableItem(nIndex, mapDefs[i]);
                            continue;
                        }
                        this.m_rowData.addElement(new VWTableItemWrapper(0, mapDefs[i]));
                    }
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public int findIndex(String fieldName) {
        int nRowIndex = -1;
        int size = this.m_rowData.size();
        if (size > 0 && fieldName != null && fieldName.length() > 0) {
            for (int i = 0; i < size; ++i) {
                String name;
                VWMapDefinition mapDef;
                VWTableItemWrapper wrapper = this.getTableItemAt(i);
                if (wrapper == null || wrapper.getValue() == null || (mapDef = (VWMapDefinition)wrapper.getValue()) == null || VWStringUtils.compare(fieldName, name = mapDef.getName()) != 0) continue;
                nRowIndex = i;
                break;
            }
        }
        return nRowIndex;
    }

    public boolean canDeleteRow(int nRowIndex) {
        if (nRowIndex == this.getRowCount() - 1) {
            return false;
        }
        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
        if (wrapper != null) {
            VWMapDefinition mapDef;
            if (!this.m_authPropertyData.getShowInheritedProperties() && (mapDef = (VWMapDefinition)wrapper.getValue()) != null && VWStringUtils.compare(mapDef.getName(), "Workflow") == 0) {
                return false;
            }
            return wrapper.canDelete();
        }
        return false;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 0: {
                return Icon.class;
            }
            case 1: 
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 3 - this.m_nColumnIndexOffset;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                return VWResource.s_nameStr;
            }
            case 2: {
                return VWResource.s_descriptionStr;
            }
        }
        return null;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        VWMapDefinition mapDef = null;
        try {
            VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
            if (wrapper != null && wrapper.getValue() != null) {
                mapDef = (VWMapDefinition)wrapper.getValue();
            }
            switch (nColumnIndex + this.m_nColumnIndexOffset) {
                case 0: {
                    if (wrapper == null) break;
                    return wrapper.getStateIcon();
                }
                case 1: {
                    if (mapDef != null) {
                        return mapDef.getName();
                    }
                    return "";
                }
                case 2: {
                    if (mapDef != null) {
                        return mapDef.getDescription();
                    }
                    return this.m_description;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                String name = (String)this.getValueAt(nRowIndex, nColumnIndex);
                if (name != null && VWStringUtils.compare(name, "Workflow") == 0) {
                    return false;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null) {
                    return wrapper.isLocal();
                }
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex + this.m_nColumnIndexOffset) {
            case 1: {
                this.onUpdateName(aValue, nRowIndex);
                break;
            }
            case 2: {
                this.onUpdateDescription(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        block9: {
            VWMapDefinition mapDef = null;
            try {
                if (aValue == null || !(aValue instanceof String)) {
                    return;
                }
                String newName = (String)aValue;
                if (newName.length() == 0) {
                    return;
                }
                VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                if (wrapper != null && wrapper.getValue() != null) {
                    mapDef = (VWMapDefinition)wrapper.getValue();
                }
                if (mapDef != null) {
                    String[] mapNames = new String[]{mapDef.getName(), newName};
                    VWMapCache mapCache = this.m_authPropertyData.getMapCache();
                    if (mapCache != null) {
                        mapCache.rename(mapNames[0], newName);
                        this.m_authPropertyData.setDirty();
                    }
                    this.fireTableCellUpdated(nRowIndex, this.getActualColumnIndex(1));
                    this.m_changedItems = new Vector();
                    this.m_changedItems.addElement(mapNames[0]);
                    this.m_changedItems.addElement(mapNames[1]);
                    this.handleRenamedMap(this.m_changedItems);
                    this.m_authPropertyData.getMapChangeEventNotifier().notifyMapChange(new VWMapChangedEvent(this, 519, this.m_changedItems));
                } else {
                    mapDef = this.m_authPropertyData.createMapDefinition(this, newName, this.m_uiContainer);
                    if (mapDef != null) {
                        mapDef.setDescription(this.m_description);
                        this.m_rowData.addElement(new VWTableItemWrapper(0, mapDef));
                        this.m_description = "";
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block9;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void onUpdateDescription(Object aValue, int nRowIndex) {
        block13: {
            block12: {
                VWMapDefinition mapDef = null;
                try {
                    try {
                        block15: {
                            block14: {
                                if (aValue == null) break block14;
                                if (aValue instanceof String) break block15;
                            }
                            Object var8_4 = null;
                            break block12;
                        }
                        VWTableItemWrapper wrapper = this.getTableItemAt(nRowIndex);
                        if (wrapper != null && wrapper.getValue() != null) {
                            mapDef = (VWMapDefinition)wrapper.getValue();
                        }
                        if (mapDef != null) {
                            if (wrapper.isInherited()) {
                                VWMapDefinition newMapDef;
                                String currentDesc = mapDef.getDescription();
                                if ((currentDesc == null || VWStringUtils.compare(aValue.toString(), currentDesc) != 0) && (newMapDef = this.m_authPropertyData.overrideMapDefinition(this, mapDef.getName(), this.m_uiContainer)) != null) {
                                    newMapDef.setDescription(aValue.toString());
                                    wrapper.overrideValue(newMapDef);
                                }
                                break block13;
                            }
                            mapDef.setDescription(aValue.toString());
                            this.m_authPropertyData.setDirty();
                            this.m_changedItems = new Vector();
                            this.m_changedItems.addElement(mapDef);
                            this.m_authPropertyData.getMapChangeEventNotifier().notifyMapChange(new VWMapChangedEvent(this, 518, this.m_changedItems));
                            break block13;
                        }
                        this.m_description = (String)aValue;
                        break block13;
                    }
                    catch (Exception ex) {
                        VWDebug.logException(ex);
                        if (this.m_authPropertyData != null) {
                            VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
                        }
                        Object var8_6 = null;
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    throw throwable;
                }
            }
            this.fireTableRowsUpdated(nRowIndex, nRowIndex);
            return;
        }
        Object var8_5 = null;
        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
    }

    private void handleRenamedMap(Vector mapNameList) {
        try {
            if (mapNameList == null || mapNameList.isEmpty()) {
                return;
            }
            Object obj1 = mapNameList.firstElement();
            Object obj2 = mapNameList.lastElement();
            if (obj1 == null || obj2 == null || !(obj1 instanceof String) || !(obj2 instanceof String)) {
                return;
            }
            String oldName = (String)obj1;
            String newName = (String)obj2;
            if (this.m_authPropertyData == null) {
                return;
            }
            VWWorkflowDefinition wfDef = this.m_authPropertyData.getWorkflowDefinition();
            if (wfDef == null) {
                return;
            }
            VWMapDefinition[] mapDefs = wfDef.getMaps();
            if (mapDefs == null) {
                return;
            }
            for (int i = 0; i < mapDefs.length; ++i) {
                VWMapNode[] mapNodes = mapDefs[i].getSteps();
                if (mapNodes == null) continue;
                block11: for (int j = 0; j < mapNodes.length; ++j) {
                    switch (VWStepUtils.getStepType(mapNodes[j])) {
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: {
                            VWInstructionDefinition[] instructionDefs;
                            VWMapNode stepDef = (VWCompoundStepDefinition)mapNodes[j];
                            if (stepDef == null || (instructionDefs = ((VWCompoundStepDefinition)stepDef).getInstructions()) == null) continue block11;
                            block12: for (int l = 0; l < instructionDefs.length; ++l) {
                                switch (instructionDefs[l].getAction()) {
                                    case 5: {
                                        String mapName = VWInstruction.CallInstructionGetSubmap(instructionDefs[l]);
                                        if (this.m_authPropertyData.getMapCache().isBaseMapExist(oldName) || VWStringUtils.compare(mapName, oldName) != 0) continue block12;
                                        VWInstruction.CallInstructionSetSubmap(instructionDefs[l], newName);
                                        continue block12;
                                    }
                                    case 1: {
                                        String mapName = VWInstruction.BeginTimerInstructionGetSubmapName(instructionDefs[l]);
                                        if (this.m_authPropertyData.getMapCache().isBaseMapExist(oldName) || VWStringUtils.compare(mapName, oldName) != 0) continue block12;
                                        VWInstruction.BeginTimerInstructionSetSubmapName(instructionDefs[l], newName);
                                    }
                                }
                            }
                            continue block11;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            String mapName;
                            VWMapNode stepDef = (VWStepDefinition)mapNodes[j];
                            if (stepDef == null || VWStringUtils.compare(mapName = ((VWStepDefinition)stepDef).getDeadlineMap(), oldName) != 0) continue block11;
                            ((VWStepDefinition)stepDef).setDeadlineMap(newName);
                            this.m_authPropertyData.setDirty();
                            continue block11;
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

